document.getElementById('start-button').addEventListener('click', startGame);

let currentBGM = '';
let bgmPosition = 0;
let bgmElement = document.getElementById('bgm');

// 変数管理オブジェクト
let gameVariables = {
    scene1VisitedCount: 0,
    flagA: false, // フラグ変数
};

function startGame() {
    document.getElementById('title-screen').style.display = 'none';
    document.getElementById('game-screen').style.display = 'block';
    showScene(0);
}

const scenes = [
    {
        id: 0, // シーンIDを追加
        background: 'scene1.jpg',
        defaultLeftCharacter: 'character1.png', // デフォルトの立ち絵
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character2.png',
        dialogue: 'これは最初のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx1.mp3',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号0', nextScene: 0 }
        ]
    },
    {
        id: 1,
        // ここを一定回数ループすると別イベントへ
        background: 'scene2.jpg',
        defaultLeftCharacter: 'character1.png',
        defaultCenterCharacter: '',
        defaultRightCharacter: 'character3.png',
        dialogue: 'これは2番目のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx2.mp3',
        choices: [
            { text: 'インデックス番号１', nextScene: 1 },
            { text: 'インデックス番号２', nextScene: 2 }
        ]
    },
    {
        id: 2,
        background: 'scene3.jpg',
        defaultLeftCharacter: 'character2.png',
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character3.png',
        dialogue: 'これは3番目のシーンです。',
        bgm: './data/bgm/',
        sfx: 'sfx3.mp3',
        choices: [
            { text: '選択肢1', nextScene: 1 },
            { text: '選択肢2', nextScene: 2 }]
    },
    {
        id: 3,
        background: 'scene3.jpg',
        defaultLeftCharacter: 'character2.png',
        defaultCenterCharacter: 'character-center.png',
        defaultRightCharacter: 'character3.png',
        dialogue: 'ゲームオーバー',
        bgm: './data/bgm/',
        sfx: 'sfx3.mp3',
        choices: []
    }
];

function showScene(index) {
    const scene = scenes.find(s => s.id === index); // シーンIDで検索
    if (!scene) {
        console.error("Scene not found:", index);//予備
        return;
    }

    // シーン訪問回数をカウント
    if (scene.id === 1) {
        gameVariables.scene1VisitedCount++;
    }

    // 分岐時に使える置き換えの変数。html内にディレクトリパスを代入することができる。
    let leftCharacter = scene.defaultLeftCharacter;
    let centerCharacter = scene.defaultCenterCharacter;
    let rightCharacter = scene.defaultRightCharacter;
    let dialogue = scene.dialogue;
    let choices = scene.choices;

    // 条件分岐の例
    if (gameVariables.scene1VisitedCount >= 5) {
        centerCharacter = ''; // 立ち絵変更
        dialogue = '何度もここに来たね。'; // セリフ変更
        choices = [{ text: '選択肢3', nextScene: 3 }]
    }

    if (gameVariables.flagA) {
        // もし、特定のシーンで別のイベントを発生させるときの実行
        // フラグの仕様：特定の要素を置き換えることが可能。
        centerCharacter = './data/img/character/lira.png';
        choices = [{ text: '選択肢3', nextScene: 3 }]
        dialogue = 'サンプルテキストなん\nちゃらかんちゃら';
    }

    document.getElementById('background').style.backgroundImage = `url(${scene.background})`;
    document.getElementById('left-character').style.backgroundImage = `url(${leftCharacter})`;
        document.getElementById('center-character').style.backgroundImage = `url(${centerCharacter})`;
    document.getElementById('right-character').style.backgroundImage = `url(${rightCharacter})`;
    changeBGM(scene.bgm);
    playSFX(scene.sfx);
    typeDialogue(dialogue, () => {
        if (choices.length > 0) {
            showChoices(choices);
        }
    });
}

//... (その他の関数は変更なし)
// 以下ver1.3同様関数。
// bgm再生
function changeBGM(bgm) {
    if (bgm === currentBGM) {
        bgmElement.currentTime = bgmPosition;
        bgmElement.play();
    } else {
        fadeOut(bgmElement, () => {
            bgmElement.src = bgm;
            bgmElement.currentTime = 0;
            bgmElement.play();
            fadeIn(bgmElement);
            currentBGM = bgm;
            bgmPosition = 0;
        });
    }
}
// フェードイン
function fadeIn(audioElement) {
    let volume = 0;
    audioElement.volume = volume;
    const fadeInInterval = setInterval(() => {
        if (volume < 1) {
            volume += 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeInInterval);
        }
    }, 100);
}
// フェードアウト
function fadeOut(audioElement, callback) {
    let volume = audioElement.volume;
    const fadeOutInterval = setInterval(() => {
        if (volume > 0) {
            volume -= 0.1;
            audioElement.volume = volume;
        } else {
            clearInterval(fadeOutInterval);
            callback();
        }
    }, 100);
}

function playSFX(sfx) {
    const sfxElement = new Audio(sfx);
    sfxElement.play();
}

bgmElement.addEventListener('timeupdate', () => {
    bgmPosition = bgmElement.currentTime;
});

function typeDialogue(text, callback) {
    const dialogueText = document.getElementById('dialogue-text');
    dialogueText.textContent = '';
    let i = 0;
    const typingSpeed = 50;
    const interval = setInterval(() => {
        if (i < text.length) {
            dialogueText.textContent += text.charAt(i);
            i++;
        } else {
            clearInterval(interval);
            setTimeout(callback, 500);
        }
    }, typingSpeed);
}

function showChoices(choices) {
    const choicesContainer = document.getElementById('choices');
    choicesContainer.style.display = 'block';
    choicesContainer.innerHTML = '';
    choices.forEach(choice => {
        const button = document.createElement('button');
        button.className = 'choice-button';
        button.textContent = choice.text;
        button.addEventListener('click', () => {
            choicesContainer.style.display = 'none';
            if (choice.nextScene === 2) {
                gameVariables.flagA = true; // フラグを立てる例
            }
            showScene(choice.nextScene);
        });
        choicesContainer.appendChild(button);
    });
}